﻿using System;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class AustralianAddressViewModelExtensions
    {
        public static AustralianAddressViewModel LoadFromAustralianAddress(this AustralianAddressViewModel viewModel, AustralianAddress address)
        {
            viewModel.UnitTypeCode = address.UnitType.HasValue ? address.UnitType.Value.ToString() : String.Empty;
            viewModel.UnitNumber = address.UnitNumber;
            viewModel.SiteName = address.SiteName;
            viewModel.LevelTypeCode = address.LevelType.HasValue ? address.LevelType.Value.ToString() : String.Empty;
            viewModel.LevelNumber = address.LevelNumber;
            viewModel.StreetNumber = address.StreetNumber;
            viewModel.LotNumber = address.LotNumber;
            viewModel.StreetName = address.StreetName;
            viewModel.StreetTypeCode = address.StreetType.HasValue ? address.StreetType.Value.ToString() : String.Empty;
            viewModel.StreetSuffixCode = address.StreetSuffixType.HasValue ? address.StreetSuffixType.Value.ToString() : String.Empty;
            viewModel.PostalDeliveryTypeCode = address.PostalDeliveryType.HasValue ? address.PostalDeliveryType.Value.ToString() : String.Empty;
            viewModel.PostalDeliveryNumber = address.PostalDeliveryNumber;
            viewModel.Suburb = address.Suburb;
            viewModel.StateCode = address.State.HasValue ? address.State.Value.ToString() : String.Empty;
            viewModel.Postcode = address.PostCode;

            return viewModel;
        }

        public static AustralianAddress ToAustralianAddress(this AustralianAddressViewModel viewModel)
        {
            return new AustralianAddress
            {
                LevelNumber = viewModel.LevelNumber,
                LevelType = EnumExtensions.TryParse<LevelType>(viewModel.LevelTypeCode),
                LotNumber = viewModel.LotNumber,
                PostCode = viewModel.Postcode,
                PostalDeliveryNumber = viewModel.PostalDeliveryNumber,
                PostalDeliveryType = EnumExtensions.TryParse<PostalDeliveryType>(viewModel.PostalDeliveryTypeCode),
                SiteName = viewModel.SiteName,
                State = EnumExtensions.TryParse<StateType>(viewModel.StateCode),
                StreetName = viewModel.StreetName,
                StreetNumber = viewModel.StreetNumber,
                StreetSuffixType = EnumExtensions.TryParse<StreetSuffixType>(viewModel.StreetSuffixCode),
                StreetType = EnumExtensions.TryParse<StreetType>(viewModel.StreetTypeCode),
                Suburb = viewModel.Suburb,
                UnitNumber = viewModel.UnitNumber,
                UnitType = EnumExtensions.TryParse<UnitType>(viewModel.UnitTypeCode)
            };
        }
    }
}